unit explorateur;

interface

uses
    Windows, SysUtils, Classes, Controls, Forms, ShellApi, Dialogs,
    ComCtrls, ImgList, ExtCtrls, StdCtrls, FileCtrl, ToolWin, ShellCtrls,
    Menus;

type
  TExplorer = class(TForm)
    Splitter1: TSplitter;
    contenu_repertoire: TListView;
    Panel1: TPanel;
    CoolBar1: TCoolBar;
    label_nb_fichiers_selectionnes: TLabel;
    label_taille_fichiers_selectionnes: TLabel;
    nb_fichiers_selectionnes: TLabel;
    taille_fichiers_selectionnes: TLabel;
    contenu: TShellTreeView;
    DriveComboBox1: TDriveComboBox;
    Popupmenu_fichiers: TPopupMenu;
    voir: TMenuItem;
    procedure DriveComboBox1Change(Sender: TObject);
    procedure contenu_repertoireSelectItem(Sender: TObject;
      Item: TListItem; Selected: Boolean);
    procedure contenu_repertoireKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure contenuChange(Sender: TObject; Node: TTreeNode);
    procedure contenu_repertoireDragOver(Sender, Source: TObject; X,
      Y: Integer; State: TDragState; var Accept: Boolean);
    procedure contenu_repertoireMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure voirClick(Sender: TObject);
  private
    { Dclarations prives }
    procedure Getfiles(listview: TListView; Directory: string);
  public
    { Dclarations publiques }
    nb_fichiers_choisis:integer;
    taille_fichiers_choisis:integer;
    chemin:string;
    procedure actualisation_contenu_repertoire;
  end;

var
  Explorer: TExplorer;

implementation

{$R *.dfm}

uses traduction, images, tout, main, config;

//Liste des fichiers du rpertoire slectionn
procedure TExplorer.Getfiles(listview: TListView; Directory: string);
var
    SearchRec: TSearchRec;
    liste:tlistitem;
    date_heure:tdatetime;

begin
    listview.Items.BeginUpdate;
    if Directory[length(Directory)] <> '\' then Directory := Directory + '\';
    chemin:=Directory;
    if FindFirst(Directory + '*.*', faDirectory, SearchRec) = 0 then
    begin
        repeat
            if (SearchRec.Attr and faDirectory <> faDirectory) and (SearchRec.Name[1] <> '.') then
            begin
                liste:=contenu_repertoire.Items.Add;
                liste.caption:=SearchRec.Name;
                liste.SubItems.Add(inttostr(SearchRec.Size));
                date_heure:=FileDateToDateTime(SearchRec.Time);
                liste.SubItems.Add(timetostr(date_heure));
                liste.SubItems.Add(datetostr(date_heure));
            end;
        until FindNext(SearchRec) <> 0;
        FindClose(SearchRec);
    end;
    listview.SortType := stText;
    listview.SortType := stNone;
    listview.Items.EndUpdate;
end;

//Changement de lecteur
procedure TExplorer.DriveComboBox1Change(Sender: TObject);
begin
    contenu.Root:=DriveComboBox1.Drive+':\';
end;

//Changement de rpertoire
procedure TExplorer.contenuChange(Sender: TObject; Node: TTreeNode);
begin
    actualisation_contenu_repertoire;
end;

//Actualisation du contenu du rpertoire slectionn
procedure TExplorer.actualisation_contenu_repertoire;
var
    nomrep:string;
    rep_parent:ttreenode;
    rep_temp:ttreenode;

begin
    if contenu.selected.Parent<>nil then
    begin
        nomrep:=contenu.selected.Text;
        if nomrep[length(nomrep)] <> '\' then nomrep := nomrep + '\';
        rep_temp:=contenu.selected;
        repeat
            rep_parent:=rep_temp.Parent;
            if (rep_parent<>nil) and (rep_parent.Level<>0) then nomrep:=rep_parent.Text+'\'+nomrep;
            rep_temp:=rep_parent;
        until rep_parent=nil;
    end;
    nomrep:=drivecombobox1.Drive+':\'+nomrep;

    contenu_repertoire.Items.BeginUpdate;
    contenu_repertoire.Items.Clear;
    GetFiles(contenu_repertoire,nomrep);
    contenu_repertoire.Items.EndUpdate;
end;

//Affiche les infos sur les fichiers slectionns
procedure TExplorer.contenu_repertoireSelectItem(Sender: TObject;
  Item: TListItem; Selected: Boolean);
var
    num_fichier:integer;

begin
    nb_fichiers_choisis:=contenu_repertoire.SelCount;
    taille_fichiers_choisis:=0;
    if nb_fichiers_choisis>0 then
        for num_fichier:=contenu_repertoire.selected.Index to contenu_repertoire.items.count-1 do
            if contenu_repertoire.Items[num_fichier].selected=true then
                inc(taille_fichiers_choisis,strtoint(contenu_repertoire.Items[num_fichier].SubItems[0]));
    nb_fichiers_selectionnes.Caption:=inttostr(nb_fichiers_choisis);
    taille_fichiers_selectionnes.Caption:=inttostr(taille_fichiers_choisis)+textes_explorateur[0];
end;

//Slection de tous les fichiers par les touches Ctrl+A
procedure TExplorer.contenu_repertoireKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
    if (key=ord('A')) and (ssCtrl in shift) then contenu_repertoire.selectall;
end;

//Fermeture de la fentre
procedure TExplorer.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    ecrit_ini_explorateur(self);
    Action := caFree;
    fenetre_explorateur:=nil;
end;

//Traduction des textes de la fentre
procedure TExplorer.FormCreate(Sender: TObject);
begin
    lit_ini_explorateur(self);
    traduction_textes_explorateur(self);
end;

//Acceptation de la rception du drag and drop sur la liste des fichiers
procedure TExplorer.contenu_repertoireDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
var
    sender_list:tlistview;
    source_list:tlistview;
begin
    accept:=false;
    if source is tlistview then
    begin
        source_list:=source as tlistview ;
        sender_list:=sender as tlistview ;
        if (sender_list.parent<>source_list.parent) then accept:=true;
    end;
end;

//Affichage du menu Popup  l'emplacement de la souris dans la listview
procedure TExplorer.contenu_repertoireMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
    fichier_selectionne:tlistitem;

begin
    if Button = mbRight then
    begin
        fichier_selectionne:=contenu_repertoire.GetItemAt(x, y);
        if fichier_selectionne<> nil then
            Popupmenu_fichiers.Popup(mouse.cursorpos.x,mouse.cursorpos.y);
    end;
end;

//Ouvre le fichier slectionn dans la listview
procedure TExplorer.voirClick(Sender: TObject);
var
    fichier:tfilestream;
    taille:integer;
    nomfichier:string;
    buffer_fichier:array of byte;
    type_fichier:string;

begin
    nomfichier:=contenu_repertoire.Selected.Caption;
    taille:=strtoint(contenu_repertoire.Selected.SubItems[0]);
    type_fichier:=uppercase(extraire_type_fichier(nomfichier));
    if (type_fichier<>'NEO') and
        (type_fichier<>'PI1') and
        (type_fichier<>'PI2') and
        (type_fichier<>'PI3') and
        (type_fichier<>'PC1') and
        (type_fichier<>'PC2') and
        (type_fichier<>'PC3') and
        (type_fichier<>'SPU') and
        (type_fichier<>'SPC') and
        (type_fichier<>'SPS') and
        (type_fichier<>'ART') and
        (type_fichier<>'TNY') and
        (type_fichier<>'TN1') and
        (type_fichier<>'TN2') and
        (type_fichier<>'TN3') and
        (type_fichier<>'DOO') and
        (type_fichier<>'MUR')
    then ShellExecute(0, nil, 'notepad.exe', pchar(chemin+nomfichier), nil, sw_normal)
    else begin
        setlength(buffer_fichier,taille);
        fichier:=TFileStream.Create(chemin+nomfichier,fmOpenRead);
        fichier.Seek(0,soFromBeginning);
        fichier.read(buffer_fichier[0],taille);
        fichier.free;

        visu_images.Show;
        try
            affiche_image(type_fichier,nomfichier,buffer_fichier);
        except
            showmessage(textes_explorateur[9]);
        end;
        setlength(buffer_fichier,0);
    end;
end;

end.

